/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.catloaf.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class CatLoafConfigValues {

    public static class IntValue
    extends Value<Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public IntValue(Integer defaultValue) {
            super(defaultValue);
        }

        @Override
        public Integer get() {
            return this.clampToLimit((Integer)super.get());
        }

        @Override
        public Integer read(JsonElement jsonElement) {
            return this.clampToLimit(jsonElement.isJsonPrimitive() ? jsonElement.getAsJsonPrimitive().getAsInt() : ((Integer)this.getDefault()).intValue());
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive((Number)this.get());
        }

        public IntValue withMin(int min) {
            this.min = min;
            return this;
        }

        public IntValue withMax(int max) {
            this.max = max;
            return this;
        }

        private int clampToLimit(int value) {
            if (value > this.max) {
                return this.max;
            }
            if (value < this.min) {
                return this.min;
            }
            return value;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }

    public static class BooleanValue
    extends Value<Boolean> {
        public BooleanValue(Boolean defaultValue) {
            super(defaultValue);
        }

        @Override
        public Boolean read(JsonElement jsonElement) {
            return jsonElement.isJsonPrimitive() ? jsonElement.getAsJsonPrimitive().getAsBoolean() : ((Boolean)this.getDefault()).booleanValue();
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive((Boolean)this.get());
        }
    }

    public static abstract class Value<T> {
        private T value;
        private final T defaultValue;

        private Value(T defaultValue) {
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public void setUnchecked(Object obj) {
            this.value = obj;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public abstract T read(JsonElement var1);

        public abstract JsonElement write();
    }
}

